function [ power ]  = temp2power( temperature , bandwidth )
% This function calculates the power generated by the device under a certain
% temperature.
%
% P ... power in Watts [W]
% k ... Boltzmann constant [W/(K*Hz)
% T ... noise temperature in Kelvin [K]
% BW ... Bandwidth in Hz

%
% P = 2*k*T*BW
%
% Input: 
% temperature in K
% bandwidth in Hz
%
% Output:
% power in Watts 

% factor = 2 from equations (two polarizations)
power = 2 * physconst('Boltzmann') * temperature * bandwidth;

end