function [ temperature ] = fluxdensity2temperature( flux_density,effective_area )
% This functions estimates the heat in an antenna with a specific telescope
% with is generated by the strength of a source. This can be used for
% example to estimate the system temperature (Tsys) with a given SEFD.
%
% The following physical
% concept is used:
%
% P ... power in Watts W
% k ... Boltzmann constant W*K^-1*Hz^-1
% T ... temperature in Kelvin K
% BW ... bandwdith in Hz
% S ... spectral power flux density (flux density) in Jy*10^-26
%
% P = k*T*BW
% P = (1/2)*S*A*BW
% k*T = S*A/2
% T = S*A/(2*k)

% Input: 
% flux density W/(m^2*Hz) = Jy*10^-26
% effective area of telescope m^2
%
% Output:
% temperature in antenna due to fluxdensity load in Kelvin K

temperature = (flux_density*effective_area)/(2*physconst('Boltzmann'));


end

