function [ headeraux ] = header_aux_calc( headeraux )
% Calculate auxiliary parameters for header

% check scan duration
if mod( headeraux.scan_duration , 1 ) ~= 0
    warning(' Scan duration is not integer value --> problem ')
end

% frame size in bit
headeraux.frame_length_bit                 = headeraux.frame_length_byte*8;

% header size in bit
headeraux.header_length_bit                = headeraux.header_length_byte*8;

% length of complete sample
headeraux.complete_sample_length_bit       = headeraux.number_of_bits_per_sample * headeraux.number_of_channels;

% number of samples
headeraux.num_samples_file                = headeraux.scan_duration * headeraux.sampling_frequency;

% data array size (without header) of total file
headeraux.data_array_length_file_bit     = headeraux.num_samples_file * 32; % bit, 32 bit word per sample

% data array size per frame
headeraux.data_array_length_bit           = headeraux.frame_length_bit - headeraux.header_length_bit; % bit

% number of frames
headeraux.number_frames_file                 = headeraux.data_array_length_file_bit / headeraux.data_array_length_bit;

% file size
headeraux.filesize_bit                  = headeraux.number_frames_file * headeraux.frame_length_bit; % bit
headeraux.filesize_byte                 = headeraux.filesize_bit / 8;

% number of frames per second
headeraux.number_frames_per_sec            = headeraux.number_frames_file / headeraux.scan_duration;

% data frame length in units of 8 bytes
headeraux.frame_length_8byte        = headeraux.frame_length_byte/8;

% number of words in data array
headeraux.num_words_per_data_array      = headeraux.data_array_length_bit / 32;

% vdif time code
[ headeraux.hyf2000 , headeraux.sec_from_hyf2000 ]   = date2vdifdate( headeraux.date_vec(1), headeraux.date_vec(2), headeraux.date_vec(3), headeraux.date_vec(4), headeraux.date_vec(5), headeraux.date_vec(6) );
headeraux.mjd       = mjuliandate( headeraux.date_vec(1), headeraux.date_vec(2), headeraux.date_vec(3), headeraux.date_vec(4), headeraux.date_vec(5), headeraux.date_vec(6) );

headeraux.ss_end    = headeraux.date_vec(6) + headeraux.scan_duration;

headeraux.mjd_end   = mjuliandate( datetime([headeraux.date_vec(1), headeraux.date_vec(2), headeraux.date_vec(3), headeraux.date_vec(4), headeraux.date_vec(5), headeraux.ss_end ]) );


fprintf(' Number of frames in total: %f\n' , headeraux.number_frames_file )
fprintf(' Number of frames per sec: %f\n' , headeraux.number_frames_per_sec )
fprintf(' Ratio of frames per sec to total number: %f\n' , headeraux.number_frames_per_sec/headeraux.number_frames_file )
fprintf(' Ratio of total number of frames to number per sec: %f\n', headeraux.number_frames_file/headeraux.number_frames_file )

% check data array length
if mod( headeraux.num_words_per_data_array , 1 ) ~= 0
    error('something wrong with data array length')
end

% check number of frames within sec
if mod( headeraux.number_frames_per_sec , 1 ) ~= 0
    fprintf(' Number of frames per sec: %f\n', headeraux.number_frames_per_sec )
    error(' Number of frames is NOT integer values. You might check the combination of scan duration and sampling rate')
end
if headeraux.number_frames_per_sec <= 1
    error(' Number of frames per seconds less than 1. Will lead to vdif error in difx library (error -5)')
end
if headeraux.number_frames_file < 3
    fprintf(' Number of frames in file: %d\n', headeraux.number_frames )
    error(' Number of frames in file must be larger than 2 ')
end

% check if data frame is integral number of total file
if mod( headeraux.filesize_bit , headeraux.frame_length_bit )  ~= 0 
    error('something wrong with file size or frame size')
end

% check complete sample length
if headeraux.complete_sample_length_bit > 32
    error('This VDIF reader only supports a maximum of 2^(num_channels)*2^(bits/sample) = 32 bits')
end

end

